import { AutocaptureConfig, PostHogConfig, Properties } from './types';
export declare function splitClassString(s: string): string[];
export declare function getClassNames(el: Element): string[];
export declare function makeSafeText(s: string | null | undefined): string | null;
export declare function getSafeText(el: Element): string;
export declare function getEventTarget(e: Event): Element | null;
export declare const autocaptureCompatibleElements: string[];
export declare function getParentElement(curEl: Element): Element | false;
export declare function shouldCaptureRageclick(el: Element | null, _config: PostHogConfig['rageclick']): boolean;
export declare function shouldCaptureDomEvent(el: Element, event: Event, autocaptureConfig?: AutocaptureConfig | undefined, captureOnAnyElement?: boolean, allowedEventTypes?: string[]): boolean;
export declare function shouldCaptureElement(el: Element): boolean;
export declare function isSensitiveElement(el: Element): boolean;
export declare function shouldCaptureValue(value: string, anchorRegexes?: boolean): boolean;
export declare function isAngularStyleAttr(attributeName: string): boolean;
export declare function getDirectAndNestedSpanText(target: Element): string;
export declare function getNestedSpanText(target: Element): string;
export declare function getElementsChainString(elements: Properties[]): string;
